//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[ChannelRow](-channel-row.md)

# ChannelRow

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [ChannelRow](-channel-row.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), showMemberPreview: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, titleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, titleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onBackground, subtitleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, subtitleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.caption, onClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })

ChannelRow

Renders a given [Chat](../ai.botstacks.sdk.state/-chat/index.md) in a Row.

This is a convenience wrapper around [Chat](../ai.botstacks.sdk.state/-chat/index.md) to handle extract the default information to display.

This is utilized in the [ChannelGroup](-channel-group.md) within UserDetailsView to show channels the current user has in common with any other user.

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this ChannelRow |
| chat | The channel to display |
| showMemberPreview | Whether to show a member preview as the subtitle. |
| titleFontStyle | [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) for the title (top text). |
| titleColor | [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) for the title. |
| subtitleFontStyle | [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) for the subtitle (bottom text). |
| subtitleColor | [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) for the subtitle. |
| onClick | called when this button is clicked |

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [ChannelRow](-channel-row.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html), imageUrls: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?&gt;, title: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), titleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, titleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onBackground, subtitle: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, subtitleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, subtitleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.caption, onClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

ChannelRow

Used to render information about a [Chat](../ai.botstacks.sdk.state/-chat/index.md).

This is utilized in the [ChannelGroup](-channel-group.md) within UserDetailsView to show channels the current user has in common with any other user.

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this ChannelRow |
| imageUrls | User image urls of members of the channel. |
| title | Text to display in title slot (top text). |
| titleFontStyle | [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) for the title (top text). |
| titleColor | [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) for the title. |
| subtitle | Optional text to display in subtitle slot (bottom text). |
| subtitleFontStyle | [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) for the subtitle (bottom text). |
| subtitleColor | [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) for the subtitle. |
| onClick | called when this button is clicked |
